//#define F_CPU		8000000
#define SPI_NUM 	6
#define MPX_NUM		5

#define byte 		uint8_t

#include<avr/io.h>
#include<avr/interrupt.h>
#include<util/delay.h>
#include"fonts.h"
#include "RTC.h"
#include "display.h"


int main(void)
{
	DDRB = 0b00101100;
	//PORTB= 0b00000100;

	DDRD = 0b00011111;
	PORTD= 0b00000000;
	
	STORE_OFF;
	_delay_ms(1);
	
	//SPI: master, [interruptos kezels], MSB elszr, 2MHz (8MHz kristly mellett)
	SPCR = (0<<SPIE) | (1<<SPE) | (1<<MSTR) | (0<<DORD) | (0<<SPR1) | (0<<SPR0);	
	//shift regiszterek alaphelyzetbe:
	for(byte i=0; i<SPI_NUM; i++)
	{
		SPDR = 0;
		while(!(SPSR & (1<<SPIF)));
	}
	STORE_ON;
	_delay_us(100);
	STORE_OFF;
	_delay_us(100);
	//SPI megszakts engedlyezse:
	SPCR |= (1<<SPIE);



	TCCR2 =  (1<<WGM21) | (1<<CS21) | (1<<CS20);
	OCR2  =  249;
	TIMSK |= 1<<OCIE2;

	sei();

	_delay_ms(10);

	RTC_Init();
	

	TimeDate_t TimeDate;
	TimeDate.Year	= 10;
	TimeDate.Month	= 11;
	TimeDate.Day	= 12;
	TimeDate.Hour	= 03;
	TimeDate.Minute = 17;
	TimeDate.Second = 30;
	//RTC_SetTimeDate(&TimeDate);

	while(1) for(byte x=0; x<100; x++)
	{
		cls();
		//if(x>=10)  for(byte i=0; i<5; i++)	MX[i+20] =  pgm_read_byte(&(FONT[0][(x/10)+48+i/5][i%5]));
		//for(byte i=0; i<5; i++) 			MX[i+25] =  pgm_read_byte(&(FONT[0][(x%10)+48+i/5][i%5]));
		/*WriteChar(20,(x/10)+48);
		WriteChar(25,(x%10)+48);*/

		RTC_GetTimeDate(&TimeDate);
		byte sec = TimeDate.Second;
		byte min = TimeDate.Minute;
		byte hour= TimeDate.Hour;
		WriteChar(0, (hour/10)+48);
		WriteChar(5, (hour%10)+48);
		WriteChar(10,(min/10)+48);
		WriteChar(15,(min%10)+48);		
		WriteChar(20,(sec/10)+48);
		WriteChar(25,(sec%10)+48);

		_delay_ms(100);



	}
	
	
	//for(byte i=0; i<5; i++) MX[i] =  pgm_read_byte(&(FONT[0][56+i/5][i%5]));

	_delay_ms(100);

	while(1);


	cls();




	while(1)
	{
		for(byte i=0; i<7; i++)  { cls(); putpixel(0,i,1); _delay_ms(100); }
		for(byte i=1; i<10; i++) { cls(); putpixel(i,6,1); _delay_ms(100); }
		for(byte i=5; i<7; i--)  { cls(); putpixel(9,i,1); _delay_ms(100); }
		for(byte i=8; i>0; i--)  { cls(); putpixel(i,0,1); _delay_ms(100); }



	}
}



byte multiplex = 0;		//multiplexlsi lps aktulis sorszma, 0-4 kztti lehet (5 oszlop)
byte spi_state = 0;		//az aktv shift regiszteres lpsek szma, 0-5 kztti lehet (6 regiszter)


//adott idkznknt - 1ms gyakorisggal - elindt egy SPI tvitel sorozatot.
//csak a kvetkez idztsi ciklusban trtnik meg a "valdi" tkapcsols.
ISR(TIMER2_COMP_vect)
{
	//(sor)multiplexls vlts:
	PORTD = (PORTD & 0b11100000);
	STORE_ON;
	_delay_us(1);
	PORTD |= (1<<multiplex);
	STORE_OFF;

	//adattvitel indtsa:
	SPDR = MX[25+multiplex];

	//multiplexls sorszm nvelse:
	if(++multiplex == MPX_NUM) multiplex = 0;
}


ISR(SPI_STC_vect)
{
	if(spi_state<SPI_NUM)
	{
		SPDR = MX[25+multiplex-(5*spi_state)];
		spi_state++;
	}
	else spi_state = 0;
}
